﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
    <meta http-equiv="Content-Type" content="text/html; charset=unicode">
<title>Zestawienie księgowe - informacja szczegółowa</title>
    <script runat="server">
        void ZestawienieKsiegowe_OnLoad(Object sender, EventArgs args){
            OkresObrachunkowy o         = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
            WynikZestKS w = null;
            if (DataContext1.Context.Contains(typeof (WynikZestKS)))
            {
                w = (WynikZestKS) DataContext1.Get(typeof (WynikZestKS));
            }
            ZestawienieKS z;
            if (w != null)
                z = w.Zestawienie;
            else
                z = (ZestawienieKS) DataContext1.Get(typeof (ZestawienieKS));
            ZestawieniaKS.Params p = new ZestawieniaKS.Params(DataContext1.Context);
            if (DataContext1.Context.Contains(typeof (ZestawieniaKS.Params)))
                p = (ZestawieniaKS.Params) DataContext1.Get(typeof (ZestawieniaKS.Params));
            DataContext1.Landscape = true;
            ZestawienieKS.Wynik wynik = param.Wynik == null ? z.ObliczZestawienie(o, p) : ZestawienieKS.Wynik.Deserialize(param.Wynik);
            ReportHeader1.Title = encode(wynik.Tytul);
            List<ZestawienieKS.Komorka> komorki = new List<ZestawienieKS.Komorka>();
            foreach (ZestawienieKS.Pozycja poz in wynik.Pozycje)
                foreach (ZestawienieKS.Komorka kom in poz.Komorki)
                    komorki.Add(kom);
            Grid1.DataSource = komorki;
        }

        Params param = null;
        [Context]
        public Params Param {
            get { return param; }
            set { param = value; }
        }



        public static String encode(String s)
        {
            return HttpUtility.HtmlEncode(s);
        }


        public class Params : ContextBase {
            ZestawienieKS zestawienie = null;

            public Params(Context cx)
              : base(cx) {
                if (cx.Contains(typeof (ZestawienieKS)))
                {
                    zestawienie = (ZestawienieKS) cx[typeof (ZestawienieKS)];
                }
                if (cx.Contains(typeof (WynikZestKS)))
                {
                    wynik = (WynikZestKS) cx[typeof (WynikZestKS)];
                    zestawienie = wynik.Zestawienie;
                }
              }

            WynikZestKS wynik = null;
            [Caption("Zapisany wynik")]
            public WynikZestKS Wynik {
                get { return wynik; }
                set { wynik = value; }
            }

            public object GetListWynik() {
                return zestawienie.Wyniki;

            }

        }
    </script>
    
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
  </HEAD>
  <body>
    <form id="ZestawienieKsiegowe" method="post" runat="server" onload="ZestawienieKsiegowe_OnLoad">
      <ea:datacontext id="DataContext1" runat="server"></ea:datacontext>
      <cc1:ReportHeader id="ReportHeader1" title="{0} | Okres obrachunkowy: {1},  Uwzględniać bufor: {2} | Typ obrotów: {3}, Za okres: {4}" runat="server"></cc1:ReportHeader><BR>
      <ea:grid id="Grid1" runat="server">
				<Columns>
					<ea:GridColumn runat="server" Width="4" Align="Center" DataMember="#" 
                        Caption="LP." ID="colLp"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Left" Caption="Pozycja~Numer" 
                        EncodeHTML="true" ID="colNumer" DataMember="Pozycja.Numer"></ea:GridColumn>					
					<ea:GridColumn runat="server" Align="Left" Caption="Pozycja~Opis" ID="GridOpis" 
                        EncodeHTML="true" DataMember="Pozycja.Opis" Width="40"></ea:GridColumn>					
					<ea:GridColumn runat="server" Width="15" Align="Left" Caption="Kolumna" 
                        ID="colKolumna" EncodeHTML="true" DataMember="NazwaKolumny"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="12" Align="Right" Caption="Wartość" 
                        ID="colWartosc" DataMember="Wartosc"  Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Left" Caption="Informacja" ID="colInfo" EncodeHTML="true" DataMember="Info"></ea:GridColumn>					
				</Columns>
			</ea:grid>
      <cc1:ReportFooter id="ReportFooter1" runat="server">
        <Subtitles>
          <cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
        </Subtitles>
      </cc1:ReportFooter>
    </form>
  </body>
</HTML>

